*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Malaoxon                                             *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\SAS code Final Models\Diagnostics.SAS";
libname EPA "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\kapp data";
/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/
data malaoxon;
     set epa.malaoxon;
run;
proc sort data=malaoxon;
     by id;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Malaoxon - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=Malaoxon);
ods rtf close;


*===> Human vs. Rat;
title1 'Human vs. Rat - Final Model 3';
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=malaoxon /*itdetails*/ method=firo tech=newrap lis=3;
      PARMS ha=0.49
			hb=0.54	
			ra=0.74
			rb=0.77	
			gha=0.38	ghab=.18		ghb=.73
			gra=.37	grab=0.59	grb=.19
			S2E=0.4998;

            rha=ha+uha;
			rra=ra+ura;
            rhb=hb+uhb;
			rrb=rb+urb;
            PRED = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-5 + H_I__M + rrb*Rat*1e-5 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ura urb ~ normal([0, 0, 0, 0],	[gha*1e-1, 
												 		 ghab*1e-3, ghb*1e-1,
														 0,    	  0,   gra*1e-1,
														 0,       0,   grab*1e-1, grb]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  predict pred out=Resid_HR;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Malaoxon human-rat.rtf" startpage=no;
%DiagnosticsHR(chemical=Malaoxon, model=3)
ods rtf close;
%Calculate_Ki(chemical=Malaoxon, Hadj=1e-5, Radj=1e-5);



*===> Adult vs. Infant;

title "Model 3 - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=malaoxon(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=.5380 adB=.5377
			ia=.3087 iB=.6116
			gada=.3900	gadab=.3057 	gadb=.5322
			gia=-.1281 	giab=-.3051 	gib=.4370
			S2E=.5767;

          	rada=ada+uada;
			radb=adB+uadb;
			ria=ia+uia;
           	rib=iB+uib;
           PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-5 + H_I__M*adult + rib*1e-5*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uada uadb uia uib ~ normal([0, 0, 0, 0],   [gada*1e-1, 
														gadab*1e-2, gadb*1e-1, 
														0,    0,     gia*1e-2, 
														0,    0,     giab*1e-1,   gib]) SUBJECT=ID out=RandID_AI;  
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  predict pred out=Resid_AI;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Malaoxon Adult-Infant.rtf" startpage=no;
%DiagnosticsAI(chemical=Malaoxon, model=3);
ods rtf close;


*===> Male vs. Female;

title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=malaoxon(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ma=.5287 mb= .6603
			fa=.4667 fB=.4465
			gha=.3804 	ghab=-.1380 	ghb=.4034
			S2E=.2649;

            rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
 			PRED = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-5 + H_I__M*male + rfb*female*1e-5 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-2, ghb*1e-1]) SUBJECT=ID out=RandID_MF; 
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  predict pred out=Resid_MF;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Malaoxon Male-Female.rtf" startpage=no;
%DiagnosticsMF(chemical=Malaoxon, model=2);
ods rtf close;


*===> Caucasian vs. Other races;

title "model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=malaoxon(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ca=.5087	cB=.4956
			ora=.4610 orB=.6665
			gha=.3746	ghab=.3327	ghb=.5167
			S2E=.5822;

            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-5 + H_I__M*caucasian + rorb*otherrace*1e-5 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-2, ghb*1e-1]) SUBJECT=ID  out=RandID_CO; 
	 ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasian ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  predict pred out=Resid_CO;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Malaoxon Caucasian-Other.rtf" startpage=no;
%DiagnosticsCO(chemical=Malaoxon, model=2);
ods rtf close;

